//Playback utilities

#include <xc.h>
#include "play.h"
#include <string.h>

void speakConfig(char n){           //uses most but not all samples
    char k;
    int32_t tempVolume=masterVolume;
    masterVolume=256;               //temporarily set volume fairly high
    playInternalWave(0,33);         //mode
    switch(mainMode){
        case MODEMIXED:        playInternalWave(0,48);break;         //mixed     
        case MODEDSELECT:      playInternalWave(0,60);break;         //select
        default:               playInternalWave(0,42);break;         //fail
    }
    playInternalWave(0,36);         //pause
    playInternalWave(0,38);         //volume
    sayNumber(tempVolume);
    playInternalWave(0,36);         //pause
    playInternalWave(0,53);         //logic
    if(activeLogicLevel==0){
        playInternalWave(0,51);         //low
    }else{
        playInternalWave(0,50);         //high
    }
    playInternalWave(0,36);         //pause
    playInternalWave(0,37);         //switch
    playInternalWave(0,19);         //4
    playInternalWave(0,33);         //mode
    switch(SW4mode){                
        case SW4TRIGGER:        playInternalWave(0,63);break;         //trigger mode     
        case SW4ANALOG:         playInternalWave(0,54);break;         //analog mode
        case SW4FREQUENCY:      playInternalWave(0,56);break;         //frequency mode
        default:                playInternalWave(0,42);break;         //fail-invalid value
    }
    playInternalWave(0,36);         //pause
    playInternalWave(0,61);         //speed
    playInternalWave(0,51);         //low
    sayNumber(SW4rawlow);
    playInternalWave(0,36);         //pause
    playInternalWave(0,61);         //speed
    playInternalWave(0,50);         //high
    sayNumber(SW4rawhigh);    
    playInternalWave(0,36);         //pause    
    switch(SW4mode){                //read out current reading if appropriate
        case SW4ANALOG:
            playInternalWave(0,54);     //analog
            playInternalWave(0,59);     //sample
            sayNumber(getAnalog());     //current analog value
            playInternalWave(0,36);     //pause    
            break;
        case SW4FREQUENCY:
            playInternalWave(0,56);     //frequency
            playInternalWave(0,59);     //sample
            sayNumber(inputFreq);       //current frequency value
            playInternalWave(0,36);     //pause    
            break;
    }
    playInternalWave(0,52);             //power
    playInternalWave(0,62);             //standby
    if(powerTimeOut){
        sayNumber(powerTimeOut);        //standby timeout
    }else{
        playInternalWave(0,34);         //off
    }
    playInternalWave(0,36);             //pause    
    for(k=0;k<n;k++){                   //if n==0, none get said
        if(SW4mode&&(k==3)){k++;}       //skip SW4 if it's doing speed control    
        playInternalWave(0,37);         //switch
        sayNumber(k+1);
        playInternalWave(0,36);         //pause
        playInternalWave(0,33);         //mode
        switch(soundMode[k]){
            case MIXED_NONE:        playInternalWave(0,34);break;                       //off
            case MIXED_LOOP:        playInternalWave(0,43);break;                       //loop
            case MIXED_SINGLE:      playInternalWave(0,47);break;                       //single
            case MIXED_CROPLOOP:    playInternalWave(0,41);playInternalWave(0,43);break;//crop-loop
            case MIXED_CROPSINGLE:  playInternalWave(0,41);playInternalWave(0,47);break;//crop-single
            case MIXED_ASR:         playInternalWave(0,40);break;                       //asr
            case MIXED_ALTLOOP:     playInternalWave(0,39);playInternalWave(0,43);break;//alt-loop
            case MIXED_ROUNDROBIN:  playInternalWave(0,46);break;                       //Round Robin
            case MIXED_RANDOM:      playInternalWave(0,45);break;                       //Random
            default: playInternalWave(0,42);break;         //fail-invalid value
        }
        if(soundMode[k]){                   //only speak these if mode is not none
            playInternalWave(0,36);         //pause
            playInternalWave(0,38);         //volume
            playInternalWave(0,51);         //low
            sayNumber(switchVolumeMin[k]);
            playInternalWave(0,36);         //pause
            playInternalWave(0,38);         //volume
            playInternalWave(0,50);         //high
            sayNumber(switchVolumeMax[k]);
            playInternalWave(0,36);         //pause
            playInternalWave(0,61);         //speed
            playInternalWave(0,51);         //low
            sayNumber(speedScaleMin[k]);
            playInternalWave(0,36);         //pause
            playInternalWave(0,61);         //speed
            playInternalWave(0,50);         //high
            sayNumber(speedScaleMax[k]);            
            playInternalWave(0,36);         //pause
            playInternalWave(0,32);         //file
            if(mixedhandles[k][0].fsize>43){
                playInternalWave(0,44);         //ok
            }else{
                playInternalWave(0,49);playInternalWave(0,44);         //not-ok
            }   
        }
        playInternalWave(0,36);         //pause
    }
    masterVolume=tempVolume;
}

char loadConfig(char *cfilename){       //load config. scans by line (CR and or LF, any non-ascii), items separated by = or , (so can't be in filenames)
    FIL cHandle;
    unsigned int nRead=0;
    char done=0;
    unsigned int tCount=0;              //how many tokens into the line?
    char p[PLENGTH]="";                 //for reading file into
    char t[TLENGTH]="";                 //for reading tokens
    unsigned int pPtr=0,tPtr=0;
    if(f_open(&cHandle,cfilename,FA_READ)!=FR_OK){return 0;}     // can't open file
    while(!done){
        if(f_read(&cHandle, &p, PLENGTH, &nRead)!=FR_OK){done=1;}
        if(nRead==0){done=1;}
        pPtr=0;
        while(pPtr<nRead){
            if(p[pPtr]<32){                 //process spaces (change to 33 to ignore)
                if(p[pPtr]<32){             //treat <32 as CR/LF token
                    parseToken(t,tCount);   //sub to process
                    tCount=0;              //start of next line
                    t[0]=0;                //blank token
                    tPtr=0;
                }
            }else{
                if((p[pPtr]=='=')||(p[pPtr]==',')){
                    parseToken(t,tCount);
                    tCount++;                       //next token
                    t[0]=0;
                    tPtr=0;
                }else{
                    t[tPtr+1]=0;                    //add to current token
                    t[tPtr]=toupper(p[pPtr]);       //ignore case
                    tPtr++;
                    if(tPtr>TLENGTH-2){tPtr=TLENGTH-2;}
                }
            }
            pPtr++;
        }
    }
    parseToken(t,tCount);                       //in case no CR/LF at end of input
    //f_close(&cHandle);                        //?not needed, not supported on readonly
    return 1;
}

void parseToken(char *token, unsigned int tNo){
    static char cToken[TLENGTH]="";                //command token at start of line
    static int entryID=0;                          //switch#
    int k=0;
    if(tNo==0){
        for(k=0;k<TLENGTH;k++){cToken[k]=token[k];}
        entryID=0;                                 //reset on new line
    }
    if(strMatch(cToken,"LOGIC")){               //set active low (default)/active high
        if(strMatch(token,"LOW")&&(tNo==1)){activeLogicLevel=0;}
        if(strMatch(token,"HIGH")&&(tNo==1)){activeLogicLevel=1;}
    }    
    if(strMatch(cToken,"SPEAKBACK")){               //how much config is spoken
        if(strMatch(token,"ALL")&&(tNo==1)){speakBack=SPEAKBACKALL;}
        if(strMatch(token,"SUMMARY")&&(tNo==1)){speakBack=SPEAKBACKSUMMARY;}
        if(strMatch(token,"NONE")&&(tNo==1)){speakBack=SPEAKBACKNONE;}
    }
    if(strMatch(cToken,"MAINMODE")){
        if(strMatch(token,"MIXED")&&(tNo==1)){mainMode=MODEMIXED;}
        if(strMatch(token,"DSELECT")&&(tNo==1)){mainMode=MODEDSELECT;}
        if(strMatch(token,"PLAYER")&&(tNo==1)){mainMode=MODEPLAYER;}
    }
    if(strMatch(cToken,"SW4MODE")){               //what function does SW4 have
        if(strMatch(token,"TRIGGER")&&(tNo==1)){SW4mode=SW4TRIGGER;}
        if(strMatch(token,"ANALOG")&&(tNo==1)){SW4mode=SW4ANALOG;}
        if(strMatch(token,"FREQUENCY")&&(tNo==1)){SW4mode=SW4FREQUENCY;}
        if(tNo==2){
            SW4rawlow=atoi(token);                      //minimum input => 0%
        }
        if(tNo==3){
            SW4rawhigh=atoi(token);                     //maximum input => 100%
        }
    }
    if(strMatch(cToken,"MASTERVOLUME")&&(tNo==1)){
        masterVolume=atoi(token);
    }
    if(strMatch(cToken,"STANDBY")&&(tNo==1)){
        powerTimeOut=atoi(token);
    }
    if((mainMode==MODEMIXED)&&(strMatch(cToken,"SWITCH1"))){entryID=1;}
    if((mainMode==MODEMIXED)&&(strMatch(cToken,"SWITCH2"))){entryID=2;}
    if((mainMode==MODEMIXED)&&(strMatch(cToken,"SWITCH3"))){entryID=3;}
    if((mainMode==MODEMIXED)&&(strMatch(cToken,"SWITCH4"))){entryID=4;}
    if((mainMode==MODEMIXED)&&(strMatch(cToken,"SWITCH5"))){entryID=5;}
    if((mainMode==MODEMIXED)&&(strMatch(cToken,"SWITCH6"))){entryID=6;}
    if((mainMode==MODEMIXED)&&(strMatch(cToken,"SWITCH7"))){entryID=7;}
    
    if((entryID>0)&&(entryID<8)&&(mainMode==MODEMIXED)){
        switch(tNo){
            case 1:                     //playback mode
                if(strMatch(token,"LOOP")){soundMode[entryID-1]=MIXED_LOOP;}
                if(strMatch(token,"SINGLE")){soundMode[entryID-1]=MIXED_SINGLE;}
                if(strMatch(token,"CROPLOOP")){soundMode[entryID-1]=MIXED_CROPLOOP;}
                if(strMatch(token,"CROPSINGLE")){soundMode[entryID-1]=MIXED_CROPSINGLE;}
                if(strMatch(token,"ASR")){soundMode[entryID-1]=MIXED_ASR;}
                if(strMatch(token,"ALTLOOP")){soundMode[entryID-1]=MIXED_ALTLOOP;}               
                if(strMatch(token,"ROUNDROBIN")){soundMode[entryID-1]=MIXED_ROUNDROBIN;}               
                if(strMatch(token,"RANDOM")){soundMode[entryID-1]=MIXED_RANDOM;}               
                break;
            case 2:                     //volume
                switchVolumeMin[entryID-1]=atoi(token);
                break;
            case 3:                     //volume
                switchVolumeMax[entryID-1]=atoi(token);
                break;
            case 4:                     //lowest speed
                speedScaleMin[entryID-1]=atoi(token);
                break;
            case 5:                     //highest speed
                speedScaleMax[entryID-1]=atoi(token);
                break;
            case 6 ... (HANDLES_PER_INPUT+5):                     //filenames
                f_open(&mixedhandles[entryID-1][tNo-6],token,FA_READ); 
                break;
         }
    }
}

int strMatch(char *a, char *b){             //check if char arrays match
    int lena=strlen(a);
    int n;
    if(strlen(a)!=strlen(b)){return 0;}     //can't be the same if different lengths
    for(n=0;n<lena;n++){
        if(a[n]!=b[n]){return 0;}
    }
    return 1;
}

void openFile(char c){                  //uses filenames[c] and sets header/wave data etc
    f[c]=f_lseek(&filetoopen[c],0);
    f[c]=f_read(&filetoopen[c], &headerBuf, HEADER_SIZE, &headerBufRead);
    WAVreadWAVHeader(&headerBuf[0], &header[c], headerBufRead);
    if(headerBufRead<44){return;}                                           //not a valid WAV, bail out
    wav_sample_rate[c] = header[c].fmtHeader.sampleRate;
	if(wav_sample_rate[c]==0){return;}                                      //invalid sample rate, bail out
    wav_num_channels[c] = header[c].fmtHeader.numChannels;
	if(wav_num_channels[c]==0){return;}                                     //invalid channel count, bail out
	wav_bytes_per_sample[c] = header[c].fmtHeader.numChannels * header[c].fmtHeader.bitsPerSample / 8;           
	if(wav_bytes_per_sample[c]==0){return;}                                 //invalid byte count, bail out
    //if we have bailed out early, flags aren't set and playback stops immediately   
    //set pointer to start of data if not after header    
    //f[c]=f_lseek(&filetoopen[c],HEADER_SIZE);
    f[c]=f_lseek(&filetoopen[c],(int)header[c].dataHeader.dataPtr-(int)headerBuf);        //seek to data start
    
    if(!playing[c]){        //start from fresh
        getDACsamples(c,0);  //consolidated into here
        getDACsamples(c,1);
        getDACsamples(c,2); 
        dacbufinuse[c]=0;
        dacbufptr[c]=0;
        fileToRead[c]=1;                
        playing[c]=1;
    }else{                  //continue from something already playing, note ISR will still be manipulating
        if(!fileToRead[c]){ //we don't need to start a new file if there's still data...
            fileToRead[c]=1;
            switch(dacbufinuse[c]){
                case 0:
                    if(dacbufend[c][1]==0){getDACsamples(c,1);}
                    if(dacbufend[c][2]==0){getDACsamples(c,2);}
                    break;
                case 1:
                    if(dacbufend[c][2]==0){getDACsamples(c,2);}
                    if(dacbufend[c][0]==0){getDACsamples(c,0);}
                    break;
                case 2:
                    if(dacbufend[c][0]==0){getDACsamples(c,0);}
                    if(dacbufend[c][1]==0){getDACsamples(c,1);}
                    break;                
            }
        }
    }
}

void playInternalWave(char c, char sNumber){                        //play synchronously (blocking)
    char done =0;
    uint32_t s=0;
    uint32_t t;
    char k;
    t=internalWave(c,0,sNumber,s);
    s=s+t;
    t=internalWave(c,1,sNumber,s);                                  //load buffers in order
    s=s+t;
    t=internalWave(c,2,sNumber,s);
    s=s+t;
    playingInt[c]=1;                                                //let ISR know there's data to play
    while(!done){
        for(k=0;k<3;k++){
            if(dacbufend[c][k]==0){                                 //as buffers empty
                t=internalWave(c,k,sNumber,s);                      //fill them
                if(!t){done=1;}                                     //until there's no data left
                s=s+t;
            }
    
        }
    }
    while((dacbufend[c][0]+dacbufend[c][1]+dacbufend[c][2])!=0){}     //wait till buffers empty
    playingInt[c]=0;    
}

void sayNumber(uint32_t n){                                                     //use internal samples to say n
    char andFlag=0;             //set if we need to say and
    char zeroFlag=1;            //clear if we don't need to say trailing zero (eg seventy-zero)
    if(n>999999999){               //billions
        sayNumber(n/1000000000);
        n=n%1000000000;
        playInternalWave(0,55);  //billion
        andFlag=1;
        zeroFlag=0;
    }
    if(n>999999){               //millions
        sayNumber(n/1000000);
        n=n%1000000;
        playInternalWave(0,5);  //million
        andFlag=1;
        zeroFlag=0;
    }
    if(n>999){                  //thousands
        sayNumber(n/1000);
        n=n%1000;
        playInternalWave(0,4);  //thousand
        andFlag=1;
        zeroFlag=0;
    }
    if(n>99){                   //hundreds
        sayNumber(n/100);
        n=n%100;
        playInternalWave(0,3);  //hundred
        andFlag=1;
        zeroFlag=0;
    }
    if(andFlag&&(n>0)){playInternalWave(0,31);}  //and
    if(n>19){                            //tens
        switch(n/10){
            case 2: playInternalWave(0,16);break;   //twenty
            case 3: playInternalWave(0,18);break;   //thirty
            case 4: playInternalWave(0,20);break;   //forty
            case 5: playInternalWave(0,22);break;   //fifty
            case 6: playInternalWave(0,24);break;   //sixty
            case 7: playInternalWave(0,26);break;   //seventy
            case 8: playInternalWave(0,28);break;   //eighty
            case 9: playInternalWave(0,30);break;   //ninety
        }
        n=n%10;
        zeroFlag=0;
    }
    switch(n){                              //units
        case 0: if(zeroFlag){playInternalWave(0,0);}break;
        case 1: playInternalWave(0,1);break;
        case 2: playInternalWave(0,15);break;
        case 3: playInternalWave(0,17);break;
        case 4: playInternalWave(0,19);break;
        case 5: playInternalWave(0,21);break;
        case 6: playInternalWave(0,23);break;
        case 7: playInternalWave(0,25);break;
        case 8: playInternalWave(0,27);break;
        case 9: playInternalWave(0,29);break;
        case 10: playInternalWave(0,2);break;
        case 11: playInternalWave(0,6);break;
        case 12: playInternalWave(0,7);break;
        case 13: playInternalWave(0,8);break;
        case 14: playInternalWave(0,9);break;
        case 15: playInternalWave(0,10);break;
        case 16: playInternalWave(0,11);break;
        case 17: playInternalWave(0,12);break;
        case 18: playInternalWave(0,13);break;
        case 19: playInternalWave(0,14);break;
    }
}

uint32_t internalWave(char c,  char buftofill, char sNumber, uint32_t s){       //load samples into c/buftofill from sNumber at s, return samples fetched (ie how much higher s will be next time)
    unsigned int k;
    unsigned int rawSamples=0;                                                  //raw samples to transfer
    unsigned int DACSamplesRead;
    int32_t DACbufp=0;                                                          //pointer    
    int32_t DACbuff=0;                                                          //fraction of pointer
    rawSamples=(INTERNAL_SAMPLE_F*DAC_BUF_SIZE)/HW_SAMPLERATE;                  //constant, so we can evaluate here
    if(rawSamples+s>=sampleSize[sNumber]){rawSamples=sampleSize[sNumber]-s;}    //check if we're near end
    DACSamplesRead=(rawSamples*HW_SAMPLERATE)/INTERNAL_SAMPLE_F;                //should be near DAC_BUF_SIZE most of the time
    dacbufend[c][buftofill]=DACSamplesRead;                                     //flag samples added
    if(rawSamples==0){return 0;}                                                //nothing left
    for(k=0;k<DACSamplesRead;k++){                                              //extract into buffer    
//        dacbuf[c][buftofill][k]=((*(sampleData[sNumber]+s+(k*INTERNAL_SAMPLE_F)/HW_SAMPLERATE))^128)<<8;  //decimation
        dacbuf[c][buftofill][k]= ((((*(sampleData[sNumber]+s+DACbufp))*(HW_SAMPLERATE-DACbuff)+(*(sampleData[sNumber]+s+DACbufp+1))*DACbuff)/HW_SAMPLERATE)^128)<<8;  //linear interpolation
        DACbuff=DACbuff+INTERNAL_SAMPLE_F;
        while(DACbuff>HW_SAMPLERATE){
            DACbuff=DACbuff-HW_SAMPLERATE;
            DACbufp++;
        }
    }
    return rawSamples;                                                          //for s to increment
}


unsigned int internalSamples(char c,  char buftofill, unsigned int f){  //load samples from internal storage into c at freq f
    unsigned int rawSamples=0;                                          //raw samples to transfer
    unsigned int k;
    if(f){                                                              //avoid div/0, does nothing, which is zero frequency output anyway
        rawSamples=(HW_SAMPLERATE*DAC_BUF_SIZE)/(f*INTERNAL_SIZE);      //INTERNAL_SIZE = 1 cycle
        if(rawSamples>DAC_BUF_SIZE){rawSamples=DAC_BUF_SIZE;}           //if f too low
        for(k=0;k<rawSamples;k++){
            dacbuf[c][buftofill][k]=sine[(k*INTERNAL_SIZE)/rawSamples]; //no interpolation
        }
    }
    dacbufend[c][buftofill]=rawSamples;
    return rawSamples;
}

//get samples func, needs buffer c and destination buffer (1,2,3)
unsigned int getDACsamples(char c, char buftofill){
    unsigned int k;
    unsigned int t1,t2;             //temps for downmixing
    unsigned int rawSamplesToRead;  //raw samples requested    
    unsigned int rawSamplesRead;    //raw samples fetched
    unsigned int bytesToRead;       //raw bytes requested
    unsigned int nRead;             //raw bytes read from file
    unsigned int DACSamplesRead;    //samples put into DAC buffer
    int32_t DACbufp=0;             //pointer    
    int32_t DACbuff=0;             //fraction of pointer
    uint32_t adjSampleRate;        //adjusted samplerate for current speed adjust
    uint32_t sectorEnd=512;        //for sector aligning reads [1,512]=>512, [513,1024]=>1024 etc
    
    //adjSampleRate=wav_sample_rate[c];     //unadjusted
    adjSampleRate=(wav_sample_rate[c]*(speedScaleMinChannel[c]*(SW4_FULL_SCALE-SW4scalevalue)+(speedScaleMaxChannel[c]*SW4scalevalue)))/(SW4_FULL_SCALE*SPEED_SCALE_DIVIDER);       //speed adjusted
    if(adjSampleRate<ADJ_SAMPLERATE_LOWER){adjSampleRate=ADJ_SAMPLERATE_LOWER;}
    if(adjSampleRate>ADJ_SAMPLERATE_UPPER){adjSampleRate=ADJ_SAMPLERATE_UPPER;}
    //dacbufVolume[c]=dacbufVolume[c];            //volume not adjusted
    dacbufVolume[c]=(dacbufVolumeMin[c]*(SW4_FULL_SCALE-SW4scalevalue)+dacbufVolumeMax[c]*SW4scalevalue)/SW4_FULL_SCALE;
    rawSamplesToRead=(DAC_BUF_SIZE*adjSampleRate)/HW_SAMPLERATE;    //not exact,usually better than 1%
    bytesToRead=rawSamplesToRead*wav_bytes_per_sample[c];
    if(bytesToRead>RAW_BUF_SIZE){bytesToRead=RAW_BUF_SIZE;}     //avoid overflow, shouldn't happen, but let's not trample on RAM
    sectorEnd=((bytesToRead+511)/512);                          //find sector end
    sectorEnd=sectorEnd*512;
    if((filetoopen[c].fptr&511)+bytesToRead>sectorEnd){bytesToRead=sectorEnd-(filetoopen[c].fptr&511);}//limit read to sector boundary to avoid double reading (maybe relax for >512 needed? eg 2446 at 64kHz Stereo 16bit)
    f[c]=f_read(&filetoopen[c], &rawBuf, bytesToRead, &nRead);  //read data from file
    rawSamplesRead=nRead/wav_bytes_per_sample[c];               //in case different (eg EOF)    
    //convert from raw to DAC (16bit mono unsigned)
    rawDACbuf[0]=rawBufLast[c];
    if(wav_num_channels[c]==1){                                                 //mono
        if(wav_bytes_per_sample[c]==1){                                         //8bit
            for(k=0;k<rawSamplesRead;k++){                                      //convert to signed 16 bit
                rawDACbuf[k+1]=(rawBuf[k]^128)<<8;
            }
        }else{                                                                  //mono 16 bit
            for(k=0;k<rawSamplesRead;k++){                                      //convert to signed 16 bit
                rawDACbuf[k+1]=rawBuf[k*2]+(rawBuf[k*2+1]<<8);                    //repack bytes
            }
        }
    }else{                                                                      //stereo
        if(wav_bytes_per_sample[c]==2){                                         //8bit
            for(k=0;k<rawSamplesRead;k++){                                      //convert to signed 16 bit
                rawDACbuf[k+1]=((rawBuf[k*2]^128)+(rawBuf[k*2+1]^128))<<7;        //downmix to mono
            }
        }else{                                                                  //16 bit stereo
            for(k=0;k<rawSamplesRead;k++){                                      //convert to signed 16 bit
                t1=rawBuf[k*4]+(rawBuf[k*4+1]<<8);                              //repack bytes and downmix
                t2=rawBuf[k*4+2]+(rawBuf[k*4+3]<<8);
                rawDACbuf[k+1]=(t1>>1)+(t2>>1);
            }
        }
    }
    rawBufLast[c]=rawDACbuf[rawSamplesRead];
    DACSamplesRead=(rawSamplesRead*HW_SAMPLERATE)/adjSampleRate;                //different algorithm avoid small amount of overrun
    for(k=0;k<DACSamplesRead;k++){                                              //extract into buffer    
        dacbuf[c][buftofill][k]=((int32_t)rawDACbuf[DACbufp]*(HW_SAMPLERATE-DACbuff)+(int32_t)rawDACbuf[DACbufp+1]*DACbuff)/HW_SAMPLERATE;    //linear interpolation
        //dacbuf[c][buftofill][k]=rawDACbuf[DACbufp];        //decimation
        DACbuff=DACbuff+adjSampleRate;
        while(DACbuff>HW_SAMPLERATE){
            DACbuff=DACbuff-HW_SAMPLERATE;
            DACbufp++;
        }
    }
    dacbufend[c][buftofill]=DACSamplesRead;
    return DACSamplesRead;
}

void __ISR(_SPI2_TX_VECTOR, IPL3SOFT) SPI2Interrupt(void){          //TX buffer empty interrupt
    //these variables for pulse counter
    static char lastState=0;            //last state of pin
    char thisState;                     //current
    static uint32_t toggleCount=0;      //count changes
    static uint32_t tCount=0;           //count time    
    
    int32_t DACdata=0;
    int32_t DACdataC[BUF_COUNT];
    char k;
    for(k=0;k<BUF_COUNT;k++){           //loop through channels
        if(playing[k]||playingInt[k]){
            DACdataC[k]=((int32_t)(dacbufVolume[k])*(int32_t)(dacbuf[k][dacbufinuse[k]][dacbufptr[k]]))>>8;        //mix in data, volume adjusted
//            DACdata=DACdata+dacbuf[k][dacbufinuse[k]][dacbufptr[k]];        //mix in data
            DACdata=DACdata+DACdataC[k];
            dacbufptr[k]++;                                                 //move pointer
            if(dacbufptr[k]>=dacbufend[k][dacbufinuse[k]]){                  //check if end of buffer
                dacbufend[k][dacbufinuse[k]]=0;                             //invalidate buffer
                dacbufptr[k]=0;                                             //reset pointer
                dacbufinuse[k]=dacbufinuse[k]+1;                            //to start of next
                if(dacbufinuse[k]>2){dacbufinuse[k]=0;}                     //or loop back to first
            }
        }        
    }
    DACdata=(DACdata*masterVolume)>>8;              //adjust volume
    if(DACdata<-32768){DACdata=-32768;clipping=1;}  //handle clipping
    if(DACdata>32767){DACdata=32767;clipping=1;}
    SPI2BUF=DACdata;                                //load I2S
    IFS1bits.SPI2TXIF=0;    //clear flag

    //frequency counter in software (limited to 46.875kHz/2)
    thisState=PORTAbits.RA3;               //SW4 (same as analog)    
    if(lastState!=thisState){
        toggleCount++;
        lastState=thisState;
    }
    tCount++;
    if(tCount>=PULSE_PERIOD){
        inputFreq=toggleCount*(HW_SAMPLERATE/(PULSE_PERIOD*2));           //divide by 2 as counting both edges
        toggleCount=0;
        tCount=0;
    }
}

int findBuffer(){
    if((playing[0]==0)&&(playingInt[0]==0)){return 0;}
    if((playing[1]==0)&&(playingInt[1]==0)){return 1;}
    if((playing[2]==0)&&(playingInt[2]==0)){return 2;}
    if((playing[3]==0)&&(playingInt[3]==0)){return 3;}
    return -1;
}

void playSampleSelect(){
    uint32_t n=0;
    char ledStat=1;
    IEC1bits.SPI2TXIE=1;        //enable TX interrupt
    delay(100);
    while(PORTBbits.RB13!=0){   //while no card detected
        if(getSW(7)==0){
            if(getSW(1)==0){n=1;}else{n=0;}             //active low
            if(getSW(2)==0){n=n+2;}                     //active low
            if(getSW(3)==0){n=n+4;}                     //active low
            if(getSW(4)==0){n=n+8;}                     //active low
            if(getSW(5)==0){n=n+16;}                    //active low
            if(getSW(6)==0){n=n+32;}                    //active low
            LEDSet(1);
            CNPUBbits.CNPUB11=0;                        //SW7 pullup off
            CNPDBbits.CNPDB11=1;                        //SW7 pulldown on - hold pin low as signal to controlling device
            playInternalWave(0,n);                      //returns on completion
            CNPDBbits.CNPDB11=0;                        //SW7 pulldown off
            CNPUBbits.CNPUB11=1;                        //SW7 pullup on
            LEDSet(0);
            delay(10);                                  //stabilise
        }
        LEDSet(ledStat);
        delay(50);             //flicker LED
        ledStat=1-ledStat;
    }
    IEC1bits.SPI2TXIE=0;        //disable TX interrupt
}